<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAssignedVaccinationSlotTable extends Migration {

	public function up()
	{
		Schema::create('assigned_vaccination_slot', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('patient_id')->unsigned();
			$table->bigInteger('vaccination_time_slot_id')->unsigned();
			$table->boolean('is_assgined');
			$table->boolean('is_reschedule')->default(False);
			$table->boolean('step1_verification')->nullable()->default(NULL);
			$table->boolean('step2_verification')->default(NULL);
		});
	}

	public function down()
	{
		Schema::drop('assigned_vaccination_slot');
	}
}