<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('firstname', 255);
			$table->string('lastname', 255);
			$table->string('email', 255);
			$table->string('mobile', 31);
			$table->string('password', 255);
			$table->string('reset_token', 512);
			$table->date('token_date');
			$table->boolean('is_active')->default(False);
			$table->string('gender', 15);
			$table->enum('user_type', array('PATEINT', 'STAFF'));
			$table->date('date_of_birth');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}