<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVaccinationDateSlotTable extends Migration {

	public function up()
	{
		Schema::create('vaccination_date_slot', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('vaccine_id')->unsigned();
			$table->bigInteger('vaccination_location_id')->unsigned();
			$table->string('name', 100)->nullable();
			$table->date('slot_date');
			$table->integer('dose_no');
		});
	}

	public function down()
	{
		Schema::drop('vaccination_date_slot');
	}
}