<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVaccineTable extends Migration {

	public function up()
	{
		Schema::create('vaccine', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100)->nullable();
			$table->text('details')->nullable();
			$table->integer('max_cooling_period_days');
			$table->integer('min_cooling_period_days');
			$table->bigInteger('batch_no');
			$table->string('vaccine_manufacturer', 200);
		});
	}

	public function down()
	{
		Schema::drop('vaccine');
	}
}