<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'last_name', 'email', 'phone', 'active', 'public_phone', 'public_sale', 'notify_chat', 'notify_interaction', 'notify_alert', 'notify_advice');

    public function projects()
    {
        return $this->hasMany('Project');
    }

    public function chats()
    {
        return $this->hasMany('Chats');
    }

}