<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Chats extends Model 
{

    protected $table = 'chats';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('pro_id', 'user_id');

    public function interaction()
    {
        return $this->hasOne('Interaction');
    }

    public function messages()
    {
        return $this->hasMany('Messages');
    }

    public function search()
    {
        return $this->belongsTo('Search');
    }

}