<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pro extends Model 
{

    protected $table = 'pros';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('uuid', 'company', 'address', 'zip', 'city', 'phone', 'email');

    public function interactions()
    {
        return $this->hasMany('Interaction');
    }

    public function chats()
    {
        return $this->hasMany('Chats');
    }

    public function ranks()
    {
        return $this->hasMany('ProRanking');
    }

}