<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProRankingTable extends Migration {

	public function up()
	{
		Schema::create('pro_ranking', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('pro_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->tinyInteger('rank')->unsigned();
			$table->string('comments', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('pro_ranking');
	}
}