<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model 
{

    protected $table = 'projects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('label', 'active');

    public function sales()
    {
        return $this->hasMany('Sale');
    }

    public function searches()
    {
        return $this->hasMany('Search');
    }

    public function progress()
    {
        return $this->hasMany('Progress');
    }

}