<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Search extends Model 
{

    protected $table = 'searches';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('project_id', 'real_estate_details_id', 'type', 'funding_type', 'rent', 'time_limit_type', 'main_house', 'active', 'cities');

    public function real_estate_detail()
    {
        return $this->hasOne('RealEstateDetails');
    }

}