<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id', true);
			$table->uuid('uuid');
			$table->string('first_name', 50);
			$table->string('last_name', 50);
			$table->string('email', 100);
			$table->string('phone', 50);
			$table->boolean('active');
			$table->boolean('public_phone');
			$table->boolean('public_sale');
			$table->boolean('notify_chat');
			$table->boolean('notify_interaction');
			$table->boolean('notify_alert');
			$table->boolean('notify_advice');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}