<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSearchesTable extends Migration {

	public function up()
	{
		Schema::create('searches', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->uuid('uuid');
			$table->integer('user_id');
			$table->integer('project_id');
			$table->mediumInteger('real_estate_details_id')->unsigned();
			$table->tinyInteger('type');
			$table->tinyInteger('funding_type')->unsigned();
			$table->boolean('rent');
			$table->tinyInteger('time_limit_type')->unsigned();
			$table->boolean('main_house');
			$table->boolean('active');
			$table->timestamps();
			$table->softDeletes();
			$table->json('cities');
		});
	}

	public function down()
	{
		Schema::drop('searches');
	}
}