<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInteractionsTable extends Migration {

	public function up()
	{
		Schema::create('interactions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('pro_id')->unsigned();
			$table->integer('search_id')->unsigned();
			$table->integer('chat_id')->nullable();
			$table->tinyInteger('interaction_type')->unsigned();
			$table->datetime('viewed_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('interactions');
	}
}