<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Pro extends Eloquent {

	protected $table = 'pros';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('uuid', 'company', 'address', 'zip', 'city', 'phone', 'email');

	public function interactions()
	{
		return $this->hasMany('Interaction');
	}

	public function chats()
	{
		return $this->hasMany('Chats');
	}

	public function ranks()
	{
		return $this->hasMany('ProRanking');
	}

}