<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Project extends Eloquent {

	protected $table = 'projects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('label', 'active');

	public function sales()
	{
		return $this->hasMany('Sale');
	}

	public function searches()
	{
		return $this->hasMany('Search');
	}

	public function progress()
	{
		return $this->hasMany('Progress');
	}

}