<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketRepliesTable extends Migration {

	public function up()
	{
		Schema::create('ticket_replies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('ticket_id')->unsigned()->nullable();
			$table->integer('employee_id')->unsigned();
			$table->text('comment')->nullable();
			$table->string('src', 150)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('ticket_replies');
	}
}