<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar');
			$table->string('name_en');
			$table->integer('user_id')->unsigned();
			$table->integer('brand_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->integer('total_qty')->nullable()->default('0');
			$table->string('color');
			$table->text('specification_ar');
			$table->text('specification_en');
			$table->string('video')->nullable();
			$table->text('detail_ar');
			$table->text('detail_en');
			$table->string('sku')->nullable();
			$table->tinyInteger('black_friday')->nullable()->default('0');
			$table->tinyInteger('today_deal')->nullable()->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}