<?php

namespace App;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('address_id', 'client_id', 'client_name', 'client_mobile', 'provider_id', 'provider_name', 'provider_mobile', 'service_id', 'service_name', 'parent_service_id', 'parent_service_name', 'date', 'status', 'service_cost', 'provider_commission', 'net_profit', 'rate', 'rate_note');

	public function Client()
	{
		return $this->belongsTo('User', 'client_id');
	}

	public function Provider()
	{
		return $this->belongsTo('User', 'client_id');
	}

	public function OrderTransactions()
	{
		return $this->hasMany('OrderTransaction', 'order_id');
	}

}