<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent_id')->default('0');
			$table->string('name', 255);
			$table->text('description')->nullable();
			$table->string('image', 255)->nullable();
			$table->string('slug', 255);
			$table->tinyInteger('live')->default('0');
			$table->integer('sort_order')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}