<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsImagesTable extends Migration {

	public function up()
	{
		Schema::create('products_images', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->integer('product_option_value_id')->nullable();
			$table->string('name', 255);
			$table->string('title', 255)->nullable();
			$table->string('alt', 255)->nullable();
			$table->string('link', 255)->nullable();
			$table->text('description')->nullable();
			$table->integer('sort_order')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products_images');
	}
}