<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsPricesTable extends Migration {

	public function up()
	{
		Schema::create('products_prices', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('primary')->default('0');
			$table->integer('product_id')->unsigned();
			$table->decimal('price', 9,2);
			$table->decimal('sale', 9,2);
			$table->integer('qty');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products_prices');
	}
}