<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsPriceTiersTable extends Migration {

	public function up()
	{
		Schema::create('products_price_tiers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->integer('maxqty')->default('0');
			$table->decimal('price', 9,2)->default('0.00');
			$table->string('code', 5)->nullable();
			$table->integer('sort_order')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products_price_tiers');
	}
}