<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Users extends Model 
{

    protected $table = 'users';
    public $timestamps = false;

    public function hasSubscription()
    {
        return $this->hasMany('App\Subscriptions');
    }

    public function hasUser()
    {
        return $this->hasOne('App\UsersInformations');
    }

    public function hasProjects()
    {
        return $this->hasMany('App\Projects');
    }

    public function hasRolesUsers()
    {
        return $this->hasMany('App\RolesUsers');
    }

    public function hasCompany()
    {
        return $this->hasOne('Companies');
    }

}