<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('settings', function(Blueprint $table) {
			$table->foreign('years_id')->references('id')->on('years')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('custodies', function(Blueprint $table) {
			$table->foreign('custody_type_id')->references('id')->on('custody_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('custodies', function(Blueprint $table) {
			$table->foreign('years_id')->references('id')->on('years')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('custodies', function(Blueprint $table) {
			$table->foreign('school_record_type_id')->references('id')->on('school_record_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('class_rooms', function(Blueprint $table) {
			$table->foreign('years_id')->references('id')->on('years')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('class_rooms', function(Blueprint $table) {
			$table->foreign('stage_id')->references('id')->on('stage')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('custody_type', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('students_count', function(Blueprint $table) {
			$table->foreign('class_room_id')->references('id')->on('class_rooms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->foreign('custody_id')->references('id')->on('custodies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('school_record_types', function(Blueprint $table) {
			$table->foreign('school_record_id')->references('id')->on('school_records')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('settings', function(Blueprint $table) {
			$table->dropForeign('settings_years_id_foreign');
		});
		Schema::table('custodies', function(Blueprint $table) {
			$table->dropForeign('custodies_custody_type_id_foreign');
		});
		Schema::table('custodies', function(Blueprint $table) {
			$table->dropForeign('custodies_years_id_foreign');
		});
		Schema::table('custodies', function(Blueprint $table) {
			$table->dropForeign('custodies_school_record_type_id_foreign');
		});
		Schema::table('class_rooms', function(Blueprint $table) {
			$table->dropForeign('class_rooms_years_id_foreign');
		});
		Schema::table('class_rooms', function(Blueprint $table) {
			$table->dropForeign('class_rooms_stage_id_foreign');
		});
		Schema::table('custody_type', function(Blueprint $table) {
			$table->dropForeign('custody_type_category_id_foreign');
		});
		Schema::table('students_count', function(Blueprint $table) {
			$table->dropForeign('students_count_class_room_id_foreign');
		});
		Schema::table('documents', function(Blueprint $table) {
			$table->dropForeign('documents_custody_id_foreign');
		});
		Schema::table('school_record_types', function(Blueprint $table) {
			$table->dropForeign('school_record_types_school_record_id_foreign');
		});
	}
}