<?php

class Custody extends Eloquent {

	protected $table = 'custodies';
	public $timestamps = true;
	protected $fillable = array('custody_type_id', 'years_id', 'item_no', 'item_des', 'item_status', 'quantity', 'type', 'insert_date', 'notebook_no', 'notebook_name', 'unit', 'shortage', 'school_record_type_id', 'record_no', 'record_description', 'notes', 'serial_number', 'custody_name', 'received_date', 'received_signature', 'recipient_signature', 'retrieved_date', 'public_number', 'private_number', 'receipt_number', 'book_supplier', 'author', 'book_title', 'publisher', 'place_of_publication', 'date_of_publication');

	public function year()
	{
		return $this->belongsTo('Year');
	}

	public function type()
	{
		return $this->belongsTo('CustodyType');
	}

	public function document()
	{
		return $this->hasOne('Document');
	}

}