<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('documents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('custody_id')->unsigned();
			$table->enum('person', array('teacher', 'student'));
			$table->integer('person_no');
			$table->string('person_name');
			$table->string('reason_leaving')->nullable();
			$table->text('documents');
		});
	}

	public function down()
	{
		Schema::drop('documents');
	}
}