<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Bill extends Model 
{

    protected $table = 'fin_bills';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function project()
    {
        return $this->belongsTo('App\Project');
    }

    public function category()
    {
        return $this->belongsTo('App\FinCategory');
    }

    public function contact()
    {
        return $this->belongsTo('App\Contact');
    }

    public function installments()
    {
        return $this->hasMany('App\Insallment');
    }

}