<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Blood_type extends Model 
{

    protected $table = 'blood_types';
    public $timestamps = true;

    public function client()
    {
        return $this->hasMany('\Client', 'blood_type_id');
    }

    public function clients()
    {
        return $this->belongsToMany('Client');
    }

    public function donationRequest()
    {
        return $this->hasMany('DonationRequest', 'blood_type_id');
    }

}