<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePageTypeTable extends Migration {

	public function up()
	{
		Schema::create('page_type', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title')->unique();
			$table->integer('layout_id')->unsigned()->nullable()->index();
			$table->text('description')->nullable();
			$table->string('icon')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('page_type');
	}
}