<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Comment extends Model 
{

    protected $table = 'comment';
    public $timestamps = true;

    public function page()
    {
        return $this->belongsTo('Page');
    }

    public function child()
    {
        return $this->hasOne('Comment', 'parent');
    }

    public function parent()
    {
        return $this->belongsTo('Comment', 'id');
    }

}