<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentTable extends Migration {

	public function up()
	{
		Schema::create('comment', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('page_id')->unsigned()->index();
			$table->integer('author')->unsigned()->nullable()->index();
			$table->string('author_email', 50);
			$table->string('author_url');
			$table->string('auhtor_ip', 100);
			$table->text('content');
			$table->integer('karma');
			$table->integer('parent')->unsigned()->index();
			$table->string('type', 30);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('comment');
	}
}