<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTokenBookTable extends Migration {

	public function up()
	{
		Schema::create('token_book', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('toilet_id')->unsigned();
			$table->string('book_no', 64);
			$table->enum('book_color', array('Blue', 'Green', 'White', 'Yellow'));
			$table->integer('serial_no_from');
			$table->integer('serial_no_to');
			$table->enum('status', array('Active', 'Closed'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('token_book');
	}
}