<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('role', array('ToiletManager', 'Helper', 'Admin'));
			$table->string('name', 255);
			$table->string('username', 255)->unique()->nullable();
			$table->string('password', 255)->nullable();
			$table->string('employee_code')->unique();
			$table->string('email', 255)->unique()->nullable();
			$table->string('aadhar_no', 12)->unique()->nullable();
			$table->string('phone', 15)->nullable();
			$table->string('address')->nullable();
			$table->string('image')->nullable();
			$table->enum('status', array('Active', 'inactive'));
			$table->boolean('master')->default(1);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}