<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommerceTable extends Migration {

	public function up()
	{
		Schema::create('commerce', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 50);
			$table->string('description');
			$table->string('commerce_code', 50);
			$table->string('api_key', 100);
			$table->tinyInteger('status');
			$table->integer('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('commerce');
	}
}