<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOwnersTable extends Migration {

	public function up()
	{
		Schema::create('owners', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('password', 255);
			$table->string('phone', 255)->nullable();
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('owners');
	}
}