<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('email');
			$table->string('password', 255)->nullable()->default('0');
			$table->string('phone');
			$table->integer('region_id')->unsigned();
			$table->tinyInteger('status')->default('0');
			$table->tinyInteger('gender')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}