<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSequenceEnrollmentsTable extends Migration {

	public function up()
	{
		Schema::create('sequence_enrollments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id');
			$table->integer('sequence_id');
			$table->integer('sequence_rollout_id');
			$table->integer('user_id');
			$table->integer('latest_step_id')->nullable();
			$table->timestamp('latest_step_at')->nullable();
			$table->integer('next_step_id')->nullable();
			$table->timestamp('action_at')->nullable();
			$table->string('status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sequence_enrollments');
	}
}