<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Manpower extends Model 
{

    protected $table = 'manpowers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function experince()
    {
        return $this->hasMany('ManpowerExperience');
    }

    public function qualification()
    {
        return $this->hasMany('EducationalQualification');
    }

    public function references()
    {
        return $this->hasMany('ManpowerReferences');
    }

    public function address()
    {
        return $this->hasMany('Address');
    }

    public function designation()
    {
        return $this->belongsTo('ManpowerDesignation');
    }

}