<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tenders', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('approved_projects', function(Blueprint $table) {
			$table->foreign('tender_id')->references('id')->on('tenders')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('project_document_details', function(Blueprint $table) {
			$table->foreign('tender_id')->references('id')->on('tenders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_manpower', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('approved_projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_manpower', function(Blueprint $table) {
			$table->foreign('manpower_id')->references('id')->on('project_manpower')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manpower_experiences', function(Blueprint $table) {
			$table->foreign('manpower_id')->references('id')->on('manpowers')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('educational_qualifications', function(Blueprint $table) {
			$table->foreign('manpower_id')->references('id')->on('manpowers')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->foreign('manpower_id')->references('id')->on('manpowers')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('manpower_references', function(Blueprint $table) {
			$table->foreign('manpower_id')->references('id')->on('manpowers')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('project_documents', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('approved_projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('project_documents', function(Blueprint $table) {
			$table->foreign('project_document_detail_id')->references('id')->on('project_document_details')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manpower_designations', function(Blueprint $table) {
			$table->foreign('designation_id')->references('id')->on('designations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manpower_designations', function(Blueprint $table) {
			$table->foreign('manpower_id')->references('id')->on('manpowers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tenders', function(Blueprint $table) {
			$table->dropForeign('tenders_employee_id_foreign');
		});
		Schema::table('approved_projects', function(Blueprint $table) {
			$table->dropForeign('approved_projects_tender_id_foreign');
		});
		Schema::table('project_document_details', function(Blueprint $table) {
			$table->dropForeign('project_document_details_tender_id_foreign');
		});
		Schema::table('project_manpower', function(Blueprint $table) {
			$table->dropForeign('project_manpower_project_id_foreign');
		});
		Schema::table('project_manpower', function(Blueprint $table) {
			$table->dropForeign('project_manpower_manpower_id_foreign');
		});
		Schema::table('manpower_experiences', function(Blueprint $table) {
			$table->dropForeign('manpower_experiences_manpower_id_foreign');
		});
		Schema::table('educational_qualifications', function(Blueprint $table) {
			$table->dropForeign('educational_qualifications_manpower_id_foreign');
		});
		Schema::table('addresses', function(Blueprint $table) {
			$table->dropForeign('addresses_manpower_id_foreign');
		});
		Schema::table('manpower_references', function(Blueprint $table) {
			$table->dropForeign('manpower_references_manpower_id_foreign');
		});
		Schema::table('project_documents', function(Blueprint $table) {
			$table->dropForeign('project_documents_project_id_foreign');
		});
		Schema::table('project_documents', function(Blueprint $table) {
			$table->dropForeign('project_documents_project_document_detail_id_foreign');
		});
		Schema::table('manpower_designations', function(Blueprint $table) {
			$table->dropForeign('manpower_designations_designation_id_foreign');
		});
		Schema::table('manpower_designations', function(Blueprint $table) {
			$table->dropForeign('manpower_designations_manpower_id_foreign');
		});
	}
}