<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTendersTable extends Migration {

	public function up()
	{
		Schema::create('tenders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('employee_id')->unsigned();
			$table->string('title');
			$table->date('opening_date');
			$table->date('closing_date');
			$table->smallInteger('require_employee')->nullable();
			$table->bigInteger('total_budget')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tenders');
	}
}