<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateManpowersTable extends Migration {

	public function up()
	{
		Schema::create('manpowers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('applicantName', 50);
			$table->string('mobile', 100)->unique();
			$table->string('email', 150)->unique();
			$table->string('gender', 50);
			$table->string('nationality', 100);
			$table->string('religion', 10);
			$table->string('profession', 100);
			$table->string('maritalStatus', 50);
			$table->integer('age');
			$table->string('bloodGroup', 5);
			$table->float('height');
			$table->string('image');
			$table->string('nid');
			$table->string('birthRegistrationNo');
			$table->string('birthDate');
			$table->string('birthPlace');
			$table->string('motherName');
			$table->string('fatherName');
			$table->string('citizenshipCertificate');
			$table->string('characterCertificate');
			$table->string('drivingLicense');
			$table->string('signature');
			$table->datetime('date');
			$table->string('designation');
			$table->uuid('unid')->unique();
		});
	}

	public function down()
	{
		Schema::drop('manpowers');
	}
}