<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Mission extends Model 
{

    protected $table = 'missions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description', 'objective', 'image', 'tags', 'dificulty', 'practice_blocks', 'challenge_blocks', 'rewards');

    public function practice_blocks()
    {
        return $this->hasMany('App\Mission\Block');
    }

    public function owner()
    {
        return $this->hasOne('App\User');
    }

    public function results()
    {
        return $this->hasMany('App\UserMissionResult');
    }

    public function challenge_blocks()
    {
        return $this->hasMany('App\Mission\Block');
    }

}