<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserGlobalStatsTable extends Migration {

	public function up()
	{
		Schema::create('user_global_stats', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->integer('experience')->default('100');
			$table->string('rank');
			$table->integer('coins');
			$table->integer('battles_won');
			$table->integer('campaigns_completed');
			$table->integer('missions_completed');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_global_stats');
	}
}