<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('location', 'title', 'address', 'detail');
    protected $visible = array('location', 'title', 'address', 'detail');

    public function creator()
    {
        return $this->hasOne('User', 'user_id');
    }

    public function users()
    {
        return $this->belongsToMany('User');
    }

    public function comments()
    {
        return $this->hasMany('Comment');
    }

    public function likes()
    {
        return $this->hasMany('Likesevents');
    }

    public function category()
    {
        return $this->belongsTo('Category');
    }

    public function hashtag()
    {
        return $this->hasMany('Tag');
    }

}