<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJobTable extends Migration {

	public function up()
	{
		Schema::create('job', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->smallInteger('status');
			$table->integer('addresss_id')->unsigned();
			$table->integer('cars_id')->unsigned();
			$table->integer('customers_id')->unsigned();
			$table->integer('washers_id')->unsigned();
			$table->integer('payments_id')->unsigned();
			$table->timestamp('jobstarttime');
			$table->timestamp('jobendtime');
			$table->json('beforephoto');
			$table->json('afterphoto');
		});
	}

	public function down()
	{
		Schema::drop('job');
	}
}