<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customers extends Model 
{

    protected $table = 'customer';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('password');

    public function address()
    {
        return $this->hasMany('Address');
    }

    public function car()
    {
        return $this->hasMany('Cars');
    }

}