<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Jobs extends Eloquent {

	protected $table = 'job';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function customer()
	{
		return $this->hasOne('Customers', 'uid');
	}

	public function address()
	{
		return $this->hasOne('Address', 'aid');
	}

	public function car()
	{
		return $this->hasOne('Cars', 'cid');
	}

	public function washer()
	{
		return $this->hasOne('Washers', 'wid');
	}

	public function payment()
	{
		return $this->hasOne('Payments', 'pid');
	}

}