<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customers extends Eloquent {

	protected $table = 'customer';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('password');

	public function address()
	{
		return $this->hasMany('Address');
	}

	public function car()
	{
		return $this->hasMany('Cars');
	}

}