<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEquipmentsTable extends Migration {

	public function up()
	{
		Schema::create('equipments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('tag', 100)->unique();
			$table->string('name', 255)->unique();
			$table->integer('process_area_id')->unsigned();
			$table->integer('parent_id')->unsigned();
			$table->softDeletes();
			$table->string('make', 40);
			$table->string('model', 40);
		});
	}

	public function down()
	{
		Schema::drop('equipments');
	}
}