<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeaveRequestTable extends Migration {

	public function up()
	{
		Schema::create('leave_request', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->timestamp('leave_start_date');
			$table->timestamp('leave_end_date');
			$table->integer('total_days');
			$table->string('status', 10);
			$table->integer('approved_by')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('leave_request');
	}
}